# Relayout Designs - Premium Elementor Addon

A powerful collection of 15 custom widgets for Elementor page builder with advanced features and professional design.

**Version:** 1.0.2  
**## 🎯 Usage

### Adding Widgets to Your Page
1. Edit any page with Elementor
2. Search for "Relayout" in the widget search bar
3. Drag and drop widgets onto your page
4. Customize using Elementor's panel
5. Publish your changes

### Widget Categories
All widgets are organized under the **"Relayout Designs"** category in Elementor for easy access.

### Premium Widget Access
- Free widgets work immediately after activation
- Premium widgets show an upgrade prompt until licensed
- After license activation, all widgets unlock instantly

## 🛠️ Troubleshooting

### Plugin Won't Activate
- Ensure Elementor is installed and activated
- Check PHP version (7.4+ required)
- Check WordPress version (5.0+ required)

### Widgets Not Showing
- Clear Elementor cache: Elementor → Tools → Regenerate CSS & Data
- Clear WordPress cache
- Deactivate and reactivate the plugin

### License Issues
- Verify license key is correct
- Check internet connection (license validation requires connection)
- Ensure license hasn't expired
- Contact support if issues persist

### Style Not Applying
- Clear browser cache
- Regenerate Elementor CSS
- Check for theme conflicts
- Ensure no custom CSS is overriding

## 📚 Documentation

Detailed documentation for each widget is available at:
[https://relayout.in/docs](https://relayout.in/docs)

## 🤝 Support

### Free Support
- Documentation: [https://relayout.in/docs](https://relayout.in/docs)
- Community Forum: [https://relayout.in/community](https://relayout.in/community)

### Premium Support
- Priority Email Support
- Live Chat Support
- Video Tutorials
- Custom Development Requests

Contact: [https://relayout.in/support](https://relayout.in/support)

## 🔄 Changelog

### Version 1.0.2
- ✅ Added complete style options to Cookie Consent Widget
- ✅ Fixed Age Calculator Widget style controls
- ✅ Added Elementor class checks to all widgets
- ✅ Improved license initialization
- ✅ Enhanced error handling
- ✅ Production-ready optimizations

### Version 1.0.1
- Initial release with 15 widgets
- RLUS license system integration
- Auto-updater functionality

## 📄 License

This plugin is licensed under GPL v2 or later.

## 👨‍💻 Developer

**Relayout Designs**  
Website: [https://relayout.in](https://relayout.in)  
Support: [https://relayout.in/support](https://relayout.in/support)

---

Made with ❤️ for the WordPress & Elementor communityes

### Free Widgets (6)

1. **Current Year Widget**
   - Dynamically displays current year
   - Prefix/suffix text support
   - Full typography controls
   - Perfect for copyright footers

2. **Timeline Widget**
   - Unlimited timeline items
   - Custom SVG icons
   - Completed/Pending status
   - Responsive design

3. **FAQ Accordion Widget**
   - Schema.org structured data for SEO
   - Single/Multiple accordion modes
   - Custom icons (Plus/Minus, Chevron, Arrow)
   - Expand/Collapse all functionality
   - Animation speed control

4. **Copy to Clipboard Widget**
   - One-click copy functionality
   - Separate display text option
   - Success message tooltip
   - Icon customization
   - Inline/Stacked layouts

5. **Disable Right Click Widget**
   - Content protection
   - Disable text selection
   - Block keyboard shortcuts
   - DevTools detection
   - Customizable warning messages

6. **Reading Progress Bar Widget**
   - Visual scroll indicator
   - Top/Bottom positioning
   - Percentage display
   - Animation styles (smooth, bounce, elastic)
   - Gradient support

### Premium Widgets (9)

1. **Checklist Manager**
   - Interactive task lists
   - Up to 10 checklist items
   - Persistent state
   - Checkbox size control

2. **Business Hours**
   - Real-time Open/Closed status
   - 7-day schedule
   - Timezone support
   - Special hours & holidays
   - Auto-highlighting current day

3. **Weather Widget**
   - No API key required
   - 100+ pre-configured cities
   - Real-time weather data
   - Temperature, humidity, wind speed
   - Multiple layout options

4. **Instagram Feed**
   - Native Instagram embeds
   - Multiple layouts (Carousel, Grid, Masonry, Pinterest)
   - Unlimited posts
   - Responsive design

5. **Age Calculator**
   - Multiple display formats
   - Auto-calculate option
   - Next birthday countdown
   - Birth day of week
   - Full styling controls

6. **Cookie Consent**
   - GDPR compliance
   - Multiple layouts (Bar, Modal, Floating)
   - Cookie categories
   - Accept/Reject/Preferences buttons
   - Complete style customization

7. **Business Chat**
   - Multi-platform support (WhatsApp, Messenger, Telegram)
   - Floating chat button
   - Position control
   - Custom messages

8. **Countdown Timer**
   - Event countdown
   - Multiple formats
   - Expiry actions
   - Custom labels

9. **Delivery Date Time**
   - Dynamic date calculation
   - Add days/hours/minutes
   - Customizable text
   - Real-time display

## License Management

### Activating Your License
1. Purchase a license from [Relayout.in](https://relayout.in/pricing)
2. Go to WordPress Admin → Settings → Relayout License
3. Enter your license key
4. Click "Activate License"
5. Premium widgets unlock immediately

### License Status Indicators
The plugin displays real-time license status:
- **Active**: All premium features available
- **Expires Soon**: Renewal recommended (30 days warning)
- **Expired**: Premium features locked, renewal required

### Automatic Updates
With an active license, you receive:
- **Automatic plugin updates**
- **New features and widgets**
- **Bug fixes and security patches**
- **Priority support**
- **1-year of updates**

### Development Mode
For testing purposes, you can enable development mode in `relayout-designs.php`:
```php
define('RELAYOUT_DESIGNS_DEV_MODE', true);
```
**Note:** Set to `false` for production!

Powered by RLUS (Relayout License & Updates System)
Server: https://www.relayout.in/

---

© 2024 Relayout Designs. All rights reserved.
