# RLUS Integration Guide for Relayout Designs

## Overview
Relayout Designs is now integrated with RLUS (Relayout License & Updates System) to provide license management and automatic updates for premium features.

## Setup Instructions

### 1. License Server Configuration
Before using the plugin, you need to configure your license server URL in the main plugin file:

```php
// Update this line in relayout-designs.php (line 32)
$this->sdk = new RLUS_SDK('plugin_relayout_designs', 'https://YOUR-DOMAIN.com/wp-json/rlus/v1/');
```

The license server URL is now configured as: `https://www.relayout.in/wp-json/rlus/v1/`

### 2. Product Setup in RLUS
1. Install RLUS on your license server
2. Go to RLUS > Updates > Add Product:
   - Product Name: Relayout Designs
   - Product Type: Plugin
   - Product ID: `plugin_relayout_designs`
   - Version: 1.0.2

### 3. License Generation
1. Go to RLUS > Generate
2. Create licenses with:
   - Product: `plugin_relayout_designs`
   - Type: Single Site / Multisite / Lifetime
   - Customer Email: customer@example.com

## Features

### Free Widgets (Always Available - 6 Total)
- Current Year Widget
- Timeline Widget
- FAQ Accordion Widget
- Copy-to-Clipboard Widget
- Disable Right Click Widget
- Reading Progress Bar Widget

### Premium Widgets (License Required)
- Checklist Manager Widget
- Business Hours Widget
- Weather Widget
- Instagram Feed Widget
- Age Calculator Widget
- Cookie Consent Widget
- Business Chat Widget
- Countdown Timer Widget

### Automatic Updates
- Licensed users receive automatic update notifications
- Secure download URLs for licensed users only
- Version control and rollback capabilities

### Admin Interface
- License management page at: Settings > Relayout License
- License activation/deactivation
- Real-time license status monitoring
- Admin notices for unlicensed installations

## Customer Usage

### License Activation
1. Install Relayout Designs plugin
2. Go to Settings > Relayout License
3. Enter license key
4. Click "Activate License"
5. Premium widgets will become available

### License Management
- View license status and expiration
- Update license key
- Deactivate license when moving sites

## Developer Functions

### Check License Status
```php
// Check if premium features are available
if (relayout_designs_is_premium_available()) {
    // Premium feature code
}

// Use helper function with fallback
$result = relayout_designs_premium_feature('Premium feature not available');
if ($result === true) {
    // Premium feature code
} else {
    echo $result; // Shows fallback message
}
```

### Global Access
```php
global $relayout_designs_license;
$is_licensed = $relayout_designs_license->is_licensed();
$license_info = $relayout_designs_license->sdk->get_license_info();
```

## File Structure
```
relayout-designs/
├── relayout-designs.php          # Main plugin file with RLUS integration
├── sdk/
│   └── class-rlus-sdk.php       # RLUS SDK
├── includes/
│   ├── timeline-widget/          # Free widget
│   ├── delivery-date-time-widget/ # Free widget
│   ├── current-year-widget/      # Free widget
│   └── [premium-widgets]/        # Premium widgets (license required)
└── RLUS-INTEGRATION.md          # This documentation
```

## Security Features
- License validation caching (1 hour for valid, 5 minutes for invalid)
- Nonce verification for API requests
- Rate limiting protection
- Encrypted license storage
- Site URL validation

## Troubleshooting

### Common Issues
1. **License not activating**: Check license server URL and network connectivity
2. **Premium widgets not showing**: Verify license is active and valid
3. **Updates not working**: Ensure license is valid and server is accessible

### Debug Mode
Add this to wp-config.php for debugging:
```php
define('WP_DEBUG', true);
define('WP_DEBUG_LOG', true);
```

Check error logs for RLUS-related messages.

## Support
For license-related issues, contact your license provider.
For technical support, check the plugin documentation or contact the developer.
