<?php
/**
 * Current Year Widget for Elementor
 *
 * @package RelayoutDesigns
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

// Make sure Elementor is active
if (!class_exists('\Elementor\Widget_Base')) {
    return;
}

class Current_Year_Widget extends \Elementor\Widget_Base {

    public function get_name() {
        return 'current_year';
    }

    public function get_title() {
        return __('Current Year', 'relayout-design');
    }

    public function get_icon() {
        return 'eicon-calendar';
    }

    public function get_categories() {
        return ['relayout-designs'];
    }

    protected function register_controls() {
        // Content Section
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Content', 'relayout-design'),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'prefix_text',
            [
                'label' => __('Prefix Text', 'relayout-design'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => '',
                'placeholder' => __('e.g., ©', 'relayout-design'),
            ]
        );

        $this->add_control(
            'suffix_text',
            [
                'label' => __('Suffix Text', 'relayout-design'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => '',
                'placeholder' => __('e.g., All rights reserved', 'relayout-design'),
            ]
        );

        $this->end_controls_section();

        // Style Section
        $this->start_controls_section(
            'style_section',
            [
                'label' => __('Style', 'relayout-design'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'text_color',
            [
                'label' => __('Text Color', 'relayout-design'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .current-year-wrapper' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'typography',
                'selector' => '{{WRAPPER}} .current-year-wrapper',
            ]
        );

        $this->add_responsive_control(
            'alignment',
            [
                'label' => __('Alignment', 'relayout-design'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __('Left', 'relayout-design'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'relayout-design'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __('Right', 'relayout-design'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'left',
                'selectors' => [
                    '{{WRAPPER}} .current-year-wrapper' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $current_year = date('Y');
        
        echo '<div class="current-year-wrapper">';
        if (!empty($settings['prefix_text'])) {
            echo '<span class="prefix-text">' . esc_html($settings['prefix_text']) . ' </span>';
        }
        
        echo '<span class="current-year">' . esc_html($current_year) . '</span>';
        
        if (!empty($settings['suffix_text'])) {
            echo ' <span class="suffix-text">' . esc_html($settings['suffix_text']) . '</span>';
        }
        echo '</div>';
    }
}
