function updateDeliveryDate() {
    const deliveryElements = document.querySelectorAll('#delivery-date');
    deliveryElements.forEach(element => {
        const daysToAdd = parseInt(element.getAttribute('data-days')) || 0;
        const hoursToAdd = parseInt(element.getAttribute('data-hours')) || 0;
        const minutesToAdd = parseInt(element.getAttribute('data-minutes')) || 0;

        let now = new Date();
        now.setDate(now.getDate() + daysToAdd);
        now.setHours(now.getHours() + hoursToAdd);
        now.setMinutes(now.getMinutes() + minutesToAdd);

        let options = { day: '2-digit', month: 'long' }; // Format: 03 March
        let formattedDate = now.toLocaleDateString('en-GB', options);

        let hours = now.getHours() % 12 || 12; // Convert to 12-hour format
        let minutes = now.getMinutes().toString().padStart(2, '0'); // Add leading zero
        let ampm = now.getHours() >= 12 ? 'PM' : 'AM';

        let deliveryTime = `${hours}:${minutes}${ampm}`;
        element.textContent = `${formattedDate}, ${deliveryTime}`;
    });
}

// Initial call to set the date immediately
updateDeliveryDate();

// Update every second
setInterval(updateDeliveryDate, 1000);