<?php
if (!defined('ABSPATH')) exit; // Exit if accessed directly

// Make sure Elementor is active
if (!class_exists('\Elementor\Widget_Base')) {
    return;
}

class Delivery_Date_Time_Widget extends \Elementor\Widget_Base {

    public function get_name() {
        return 'delivery_date_time';
    }

    public function get_title() {
        if (!function_exists('relayout_designs_is_premium_available') || !relayout_designs_is_premium_available()) {
            return __('Delivery Date and Time', 'relayout-design') . ' <span style="color: #ff6b35; font-weight: bold; font-size: 10px; background: #fff3f0; padding: 2px 6px; border-radius: 3px; margin-left: 5px;">PRO</span>';
        }
        return __('Delivery Date and Time', 'relayout-design');
    }

    public function get_icon() {
        return 'eicon-clock';
    }

    public function get_categories() {
        return ['relayout-designs'];
    }

    public function get_script_depends() {
        return ['delivery-date-time-script'];
    }

    protected function register_controls() {
        // Content Section
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Delivery Settings', 'relayout-design'),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'delivery_text',
            [
                'label' => __('Delivery Text', 'relayout-design'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Get on before', 'relayout-design'),
                'placeholder' => __('Enter your custom text', 'relayout-design'),
            ]
        );

        $this->add_control(
            'days_to_add',
            [
                'label' => __('Days to Add', 'relayout-design'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 0,
                'min' => 0,
                'max' => 365,
                'step' => 1,
            ]
        );

        $this->add_control(
            'hours_to_add',
            [
                'label' => __('Hours to Add', 'relayout-design'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 0,
                'min' => 0,
                'max' => 23,
                'step' => 1,
            ]
        );

        $this->add_control(
            'minutes_to_add',
            [
                'label' => __('Minutes to Add', 'relayout-design'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 0,
                'min' => 0,
                'max' => 59,
                'step' => 1,
            ]
        );

        $this->end_controls_section();

        // Style Section - Title
        $this->start_controls_section(
            'title_style_section',
            [
                'label' => __('Title Style', 'relayout-design'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => __('Title Color', 'relayout-design'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} h1' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => __('Title Typography', 'relayout-design'),
                'selector' => '{{WRAPPER}} h1',
                'exclude' => ['line_height'], // Optional: Exclude line-height if not needed
            ]
        );

        $this->end_controls_section();

        // Style Section - Date and Time
        $this->start_controls_section(
            'date_time_style_section',
            [
                'label' => __('Date and Time Style', 'relayout-design'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'date_time_color',
            [
                'label' => __('Date and Time Color', 'relayout-design'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} #delivery-date' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'date_time_typography',
                'label' => __('Date and Time Typography', 'relayout-design'),
                'selector' => '{{WRAPPER}} #delivery-date',
                'exclude' => ['line_height'], // Optional: Exclude line-height if not needed
            ]
        );

        $this->end_controls_section();

        // Style Section - Alignment
        $this->start_controls_section(
            'alignment_style_section',
            [
                'label' => __('Alignment', 'relayout-design'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'text_alignment',
            [
                'label' => __('Text Alignment', 'relayout-design'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __('Left', 'relayout-design'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'relayout-design'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __('Right', 'relayout-design'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'left',
                'selectors' => [
                    '{{WRAPPER}} h1' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        // Check if premium features are available
        if (!function_exists('relayout_designs_is_premium_available') || !relayout_designs_is_premium_available()) {
            $upgrade_prompt = relayout_designs_show_upgrade_prompt('Delivery Date Time Widget');
            if ($upgrade_prompt) {
                echo $upgrade_prompt;
                return;
            }
        }
        
        $settings = $this->get_settings_for_display();
        $delivery_text = $settings['delivery_text'];
        $days = (int) $settings['days_to_add'];
        $hours = (int) $settings['hours_to_add'];
        $minutes = (int) $settings['minutes_to_add'];
        ?>
        <h1><?php echo esc_html($delivery_text); ?> <span id="delivery-date" data-days="<?php echo esc_attr($days); ?>" data-hours="<?php echo esc_attr($hours); ?>" data-minutes="<?php echo esc_attr($minutes); ?>"></span></h1>
        <?php
    }
}