<?php
if (!defined('ABSPATH')) exit; // Exit if accessed directly

// Make sure Elementor is active
if (!class_exists('\Elementor\Widget_Base')) {
    return;
}

class History_Timeline_Widget extends \Elementor\Widget_Base {

    public function get_name() {
        return 'history_timeline';
    }

    public function get_title() {
        return __('History Timeline', 'relayout-design');
    }

    public function get_icon() {
        return 'eicon-time-line';
    }

    public function get_categories() {
        return ['relayout-designs'];
    }

    protected function register_controls() {
        // Timeline Content Section
        $this->start_controls_section(
            'timeline_section',
            [
                'label' => __('Timeline Items', 'relayout-design'),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'step_title',
            [
                'label' => __('Step Title', 'relayout-design'),
                'type'  => \Elementor\Controls_Manager::TEXT,
                'default' => __('Step Title', 'relayout-design'),
            ]
        );

        $repeater->add_control(
            'step_description',
            [
                'label' => __('Step Description', 'relayout-design'),
                'type'  => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('Description of the step.', 'relayout-design'),
            ]
        );

        $repeater->add_control(
            'step_icon',
            [
                'label' => __('Custom Icon (SVG)', 'relayout-design'),
                'type'  => \Elementor\Controls_Manager::MEDIA,
                'media_types' => ['svg'],
                'default' => ['url' => ''],
            ]
        );

        $repeater->add_control(
            'step_status',
            [
                'label' => __('Status', 'relayout-design'),
                'type'  => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'completed' => __('Completed', 'relayout-design'),
                    'pending' => __('Pending', 'relayout-design'),
                ],
                'default' => 'pending',
            ]
        );

        $this->add_control(
            'timeline_items',
            [
                'label' => __('Timeline Steps', 'relayout-design'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [],
                'title_field' => '{{{ step_title }}}',
            ]
        );

        $this->end_controls_section();

        // Styling Section - Title
        $this->start_controls_section(
            'title_style_section',
            [
                'label' => __('Title Style', 'relayout-design'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => __('Title Color', 'relayout-design'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .timeline-item .text h3' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .timeline-item .text h3',
            ]
        );

        $this->end_controls_section();

        // Styling Section - Description
        $this->start_controls_section(
            'desc_style_section',
            [
                'label' => __('Description Style', 'relayout-design'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'desc_color',
            [
                'label' => __('Description Color', 'relayout-design'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .timeline-item .text p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'desc_typography',
                'selector' => '{{WRAPPER}} .timeline-item .text p',
            ]
        );

        $this->end_controls_section();

        // Styling Section - Icon
        $this->start_controls_section(
            'icon_style_section',
            [
                'label' => __('Icon Style', 'relayout-design'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'icon_size',
            [
                'label' => __('Icon Size', 'relayout-design'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .icon' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .icon img' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'completed_icon_color',
            [
                'label' => __('Completed Icon Color', 'relayout-design'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .completed .icon' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'pending_icon_color',
            [
                'label' => __('Pending Icon Color', 'relayout-design'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pending .icon' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'timeline_line_color',
            [
                'label' => __('Timeline Line Color', 'relayout-design'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#12d2bf', // Default value matching your CSS
                'selectors' => [
                    '{{WRAPPER}} .timeline-item::before' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        ?>
        <div class="timeline">
            <?php foreach ($settings['timeline_items'] as $item): ?>
                <div class="timeline-item <?php echo esc_attr($item['step_status']); ?>">
                    <div class="icon">
                        <?php if (!empty($item['step_icon']['url'])): ?>
                            <img src="<?php echo esc_url($item['step_icon']['url']); ?>" alt="Step Icon" class="step-icon" />
                        <?php else: ?>
                            <?php echo $item['step_status'] === 'completed' ? '✔' : '○'; ?>
                        <?php endif; ?>
                    </div>
                    <div class="text">
                        <h3><?php echo esc_html($item['step_title']); ?></h3>
                        <p><?php echo esc_html($item['step_description']); ?></p>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
        <?php
    }
}